
/*
 * app.c
 *
 *  Created on: Mar 29, 2018
 *      Author: a0219345
 */

/* 
*   Copyright (C) 2019Texas Instruments Incorporated - http://www.ti.com/ 
* 
* 
*  Redistribution and use in source and binary forms, with or without 
*  modification, are permitted provided that the following conditions 
*  are met:
*
*    Redistributions of source code must retain the above copyright 
*    notice, this list of conditions and the following disclaimer.
*
*    Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the 
*    documentation and/or other materials provided with the   
*    distribution.
*
*    Neither the name of Texas Instruments Incorporated nor the names of
*    its contributors may be used to endorse or promote products derived
*    from this software without specific prior written permission.
*
*  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS 
*  "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT 
*  LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
*  A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT 
*  OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, 
*  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT 
*  LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
*  DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
*  THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT 
*  (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE 
*  OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/ 



//*****************************************************************************
//
// app_oemsocket.c - NDK Ethernet hook functions declare and open rawsocket
//                   udpsocket to application
//
//
//*****************************************************************************


#define _INCLUDE_NIMU_CODE  //for include header

/* XDCtools Header files */
#include <xdc/std.h>
#include <xdc/cfg/global.h>
#include <xdc/runtime/Error.h>
#include <xdc/runtime/Memory.h>
#include <xdc/runtime/System.h>

/* BIOS Header files */
#include <ti/sysbios/BIOS.h>
#include <ti/sysbios/knl/Clock.h>
#include <ti/sysbios/knl/Task.h>

 /* NDK Header files */
#include <ti/ndk/inc/netmain.h>
#include <ti/ndk/inc/_stack.h>
#include <ti/ndk/inc/socket.h>
#include <ti/ndk/inc/stack/inc/nimuif.h>
#include <ti/ndk/inc/tools/console.h>

#include <ti/ndk/inc/nettools/inc/inet.h>
#include <ti/sysbios/hal/Seconds.h>

/* wolfSSL Header files */
#include <wolfssl/ssl.h>
#include <wolfssl/certs_test.h>

#include <oem\app_oemsocket.h>

#include <wolfssl/wolfssl/internal.h>//Rio: Fix User IO

#define TCPPACKETSIZE 1024
#define UDPPORT 7
static HANDLE hEchoUdp = 0;
static HANDLE hTLSClient = 0;
static HANDLE hTLSServer = 0;

#define NUMTCPWORKERS 3
#define TCPPORT_Client 1000
#define TCPPORT_Server 2000

#if 0//Rio: Original
#define IP_ADDR "xxx.xxx.x.xxx"
#else
#define IP_ADDR "192.168.1.10"//Rio: This is TLS Server Address.
#endif
//*****************************************************************************
//
// Print mac address
//
//*****************************************************************************
void print_mac(void)
{
    UINT8  mac_address[6];
    NIMU_IF_REQ if_req;
    int ret_code ;
    memset(mac_address,0,6);

    if_req.index = 1;
    ret_code = NIMUIoctl (NIMU_GET_DEVICE_MAC, &if_req, &mac_address, sizeof(mac_address));

    UART_printf ("\n Rio Debug ==> Ethernet MAC Address   : 0x%x-0x%x-0x%x-0x%x-0x%x-0x%x\n\n\n",
                       mac_address[0], mac_address[1], mac_address[2],
                       mac_address[3], mac_address[4], mac_address[5]);

    if (ret_code < 0)
    {
        UART_printf ("\n Rio Debug ==> NIMUIOCTL Failed with error code: %d\n",ret_code);
        return;
    }
}

//*****************************************************************************
//
// Daemon task function when udp packets is received
//
//*****************************************************************************
int dtask_udp_echo( SOCKET s, UINT32 unused )
{
    struct sockaddr_in sin1;
    struct timeval     to;
    int                i,tmp;
    char               *pBuf;
    HANDLE             hBuffer;

    (void)unused;

    UART_printf (" Rio Debug ==> dtask_udp_echo running \n");

    /*
     * wolfSSL library needs time() for validating certificates.
     * USER STEP: Set up the current time in seconds below.
     */

    //timer_settime();

    // Configure our socket timeout to be 3 seconds
    to.tv_sec  = 3;
    to.tv_usec = 0;
    setsockopt( s, SOL_SOCKET, SO_SNDTIMEO, &to, sizeof( to ) );
    setsockopt( s, SOL_SOCKET, SO_RCVTIMEO, &to, sizeof( to ) );

    for(;;)
    {
        tmp = sizeof( sin1 );
        i = (int)recvncfrom( s, (void **)&pBuf, 0,(struct sockaddr *)&sin1, &tmp, &hBuffer );

        // Spit any data back out
        if( i >= 0 )
        {
            sendto( s, pBuf, i, 0,(struct sockaddr *)&sin1, sizeof(sin1) );
            recvncfree( hBuffer );
        }
        else
            break;
    }

    // Since the socket is still open, return "1"
    // (we need to leave UDP sockets open)
    return(1);
}

//*****************************************************************************
//
// Hook function when network service close
//
//*****************************************************************************
void netCloseHook(void)
{
    DaemonFree(hEchoUdp);

    // Kill any active console
    ConsoleClose();
}

//------------Rio: Add in WolfSSL Server parts-------------------------------//

/*
 *  ======== exitApp ========
 *  Cleans up the SSL context and exits the application
 */
void exitApp(WOLFSSL_CTX* ctx) {
    if (ctx != NULL) {
        wolfSSL_CTX_free(ctx);
        wolfSSL_Cleanup();
    }

    BIOS_exit(-1);
}

/*
 *  ======== tcpWorker ========
 *  Task to handle TCP connection. Can be multiple Tasks running
 *  this function.
 */
int32_t tcpServerHandler_init(void)
{

    Task_Params params;
    Task_Handle task;
    Error_Block eb;

    Task_Params_init(&params);
    Error_init(&eb);

    params.priority = 5;
    params.stackSize = 32768;
    params.arg0 = 0;
    params.arg1 = 0;

    /* Read data from config (or default values) */
    task = Task_create(tcpServerHandler, &params, &eb);

    if (task == NULL)
    {
        UART_printf("------------------Task '%s', TCP: tcpServerHandler failed, Error %s\n", Error_getMsg(&eb));
        return ERROR_TASK_CREATE;
    }
    else
    {
        UART_printf("------------------TCP: tcpServerHandler Success !!\n");
        return ERROR_SUCCESS;
    }

}


Void tcpServerHandler_worker(UArg arg0, UArg arg1)
{
    int clientfd = 0;
    int nbytes;
    Bool flag = TRUE;//Rio
    char *buffer;
    Error_Block eb;
    WOLFSSL* ssl = (WOLFSSL *)arg0;

    fdOpenSession(TaskSelf());
    clientfd = wolfSSL_get_fd(ssl);
    UART_printf("tcpServerHandler_worker: start clientfd = 0x%x\n", clientfd);

    /* Make sure Error_Block is initialized */
    Error_init(&eb);

    /* Get a buffer to receive incoming packets. Use the default heap. */
    buffer = Memory_alloc(NULL, TCPPACKETSIZE, 0, &eb);
    if (buffer == NULL) {
        UART_printf("tcpServerHandler_worker: failed to alloc memory\n");
        Task_exit();
    }


    /* Loop while we receive data */
    while (flag) {
        char ack[] = "wolfSSL's AM335 SK  Series Connected Launchpad Heard you loud and clear!!! -Kaleb\n";
        nbytes = wolfSSL_read(ssl, (char *)buffer, TCPPACKETSIZE);
        if (nbytes > 0) {
            /* Echo the data back */
            wolfSSL_write(ssl, (char *)ack, strlen(ack));
        }
        else {
            wolfSSL_free(ssl);
            fdClose((SOCKET)clientfd);
            flag = FALSE;
        }
    }
    UART_printf("tcpServerHandler_worker stop clientfd = 0x%x\n", clientfd);

    /* Free the buffer back to the heap */
    Memory_free(NULL, buffer, TCPPACKETSIZE);

    fdCloseSession(TaskSelf());
    /*
     *  Since deleteTerminatedTasks is set in the cfg file,
     *  the Task will be deleted when the idle task runs.
     */
    Task_exit();
}

/*
 *  ======== tcpHandler ========
 *  Creates new Task to handle new TCP connections.
 */
int tcpServerHandler(UArg arg0, UArg arg1)
{
    int lSocket;
    struct sockaddr_in sLocalAddr;
    int clientfd;
    struct sockaddr_in client_addr;
    int addrlen=sizeof(client_addr);
    int optval;
    int optlen = sizeof(optval);
    int status;
    Task_Handle taskHandle;
    Task_Params taskParams;
    Error_Block eb;

    Seconds_set(1476377542);

    fdOpenSession(TaskSelf());

    wolfSSL_Init();
    WOLFSSL_CTX* ctx = NULL;

    if ((ctx = wolfSSL_CTX_new(wolfTLSv1_2_server_method())) == NULL) {
        UART_printf("tcpServerHandler: wolfSSL_CTX_new error.\n");
       exitApp(ctx);
    }

    //Rio: If error is here, EPOCH time will solve it
    if (wolfSSL_CTX_load_verify_buffer(ctx, ca_cert_der_2048,
                                  sizeof(ca_cert_der_2048)/sizeof(char),
                                  SSL_FILETYPE_ASN1) != SSL_SUCCESS) {
        UART_printf("tcpServerHandler: Error loading ca_cert_der_2048"
                     " please check the wolfssl/certs_test.h file.\n");
       exitApp(ctx);
    }

    if (wolfSSL_CTX_use_certificate_buffer(ctx, server_cert_der_2048,
                                  sizeof(server_cert_der_2048)/sizeof(char),
                                  SSL_FILETYPE_ASN1) != SSL_SUCCESS) {
        UART_printf("tcpServerHandler: Error loading server_cert_der_2048,"
                     " please check the wolfssl/certs_test.h file.\n");
       exitApp(ctx);
    }

    if (wolfSSL_CTX_use_PrivateKey_buffer(ctx, server_key_der_2048,
                                  sizeof(server_key_der_2048)/sizeof(char),
                                  SSL_FILETYPE_ASN1) != SSL_SUCCESS) {
        UART_printf("tcpServerHandler: Error loading server_key_der_2048,"
                     " please check the wolfssl/certs_test.h file.\n");
       exitApp(ctx);
    }

    lSocket = socket(AF_INET, SOCK_STREAM, IPPROTO_TCP);
    if (lSocket == -1) {
        UART_printf("tcpServerHandler: socket failed\n");
        Task_exit();
    }

    memset((char *)&sLocalAddr, 0, sizeof(sLocalAddr));
    sLocalAddr.sin_family = AF_INET;
    //sLocalAddr.sin_len = sizeof(sLocalAddr);//Rio
    sLocalAddr.sin_addr.s_addr = htonl(INADDR_ANY);

#if 0
    sLocalAddr.sin_port = htons(arg0);
#else
    sLocalAddr.sin_port = htons(TCPPORT_Server);
#endif

#if 1//Rio: Fix the User IO Callback.
    /* Register callbacks */
    wolfSSL_SetIORecv(ctx, my_IORecv);
    wolfSSL_SetIOSend(ctx, my_IOSend);
#endif

    status = bind(lSocket, (struct sockaddr *)&sLocalAddr, sizeof(sLocalAddr));
    if (status < 0) {
        UART_printf("tcpServerHandler: bind failed\n");
        fdClose((SOCKET)lSocket);
        exitApp(ctx);
    }

    if (listen(lSocket, NUMTCPWORKERS) != 0){
        UART_printf("tcpServerHandler: listen failed\n");
        fdClose((SOCKET)lSocket);
        exitApp(ctx);
    }

    if (setsockopt(lSocket, SOL_SOCKET, SO_KEEPALIVE, &optval, optlen) < 0) {
        UART_printf("tcpServerHandler: setsockopt failed\n");
        fdClose((SOCKET)lSocket);
        exitApp(ctx);
    }

    while (TRUE) {
         WOLFSSL* ssl;

        /* Wait for incoming request */
        if ((clientfd = accept(lSocket, (struct sockaddr*)&client_addr,
            &addrlen)) == -1) {
            UART_printf("tcpServerHandler: Accept failed %d\n");
            exitApp(ctx);
        }

        /* Init the Error_Block */
        Error_init(&eb);
        if ((ssl = wolfSSL_new(ctx)) == NULL) {
            UART_printf("tcpHandler: wolfSSL_new error.\n");
            exitApp(ctx);
        }

        wolfSSL_set_fd(ssl, clientfd);

        /* Initialize the defaults and set the parameters. */
        Task_Params_init(&taskParams);
        taskParams.arg0 = (UArg)ssl;
        taskParams.stackSize = 16384;
        taskHandle = Task_create((Task_FuncPtr)tcpServerHandler_worker, &taskParams, &eb);
        if (taskHandle == NULL) {
            UART_printf("tcpServerHandler: Failed to create new Task\n");
        }
    }
}

/*
 *  ======== tcpHandler ========
 *  Creates new Task to handle new TCP connections.
 */
static uint32_t listen_timeout;
static uint16_t port;

int32_t tcpClientHandler_init(void)
{
    Task_Params params;
    Task_Handle task;
    Error_Block eb;

    Task_Params_init(&params);
    Error_init(&eb);

    params.priority = 5;
    params.stackSize = 32768;
    params.arg0 = 0;
    params.arg1 = 0;

    /* Read data from config (or default values) */
    port = 23;
    listen_timeout = 10000;

    task = Task_create(tcpClientHandler, &params, &eb);

    if (task == NULL)
    {
        UART_printf("------------------Task '%s', TCP: tcpClientHandler failed, Error %s\n", Error_getMsg(&eb));
        return ERROR_TASK_CREATE;
    }
    else
    {
        UART_printf("------------------TCP: tcpClientHandler Success !!\n");
        return ERROR_SUCCESS;
    }
}

int tcpClientHandler(UArg arg0, UArg arg1)//Original

{
    int sockfd;
    int ret;
    struct sockaddr_in servAddr;
    Error_Block eb;
    Bool flag = TRUE;
    Bool internal_flag = TRUE;
    int nbytes;
    char *buffer;
    char msg[] = "Hello from Rio AM335 SK EVM";
    int err;
    char server_add_str[20];
    char err_buffer[80];

#if 1
//Rio: Time test
    time_t t;
    struct tm *ltm;
    char *curTime;

    //https://www.epochconverter.com/ Rio: Go to this web to convert EPOCH time
    //https://www.wolfssl.com/forums/topic862-solved-asnbeforedatee-when-calling-ctxloadverifybuffer.html

    Seconds_set(1476377542);
    t = time(NULL);
    ltm = localtime(&t);
    curTime = asctime(ltm);
    UART_printf("Rio: Time(GMT): %s\n", curTime);
#endif

    WOLFSSL* ssl = (WOLFSSL *) arg0;


    if (!fdOpenSession( (HANDLE)Task_self() ))
    {
        UART_printf("---------- fdOpenSession error, function fail & return ----------\n");
        return;
    }
    else
    {
        UART_printf("---------- fdOpenSession Success !! ----------\n");
    }


    wolfSSL_Init();
    Task_sleep(1000);
    WOLFSSL_CTX* ctx = NULL;


    UART_printf("---------- Rio: tcpClientHandler: Started ----------.\n");

    ctx = wolfSSL_CTX_new(wolfTLSv1_2_client_method());
    if (ctx == 0) {
        UART_printf("tcpHandler: wolfSSL_CTX_new error.\n");
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfTLSv1_2_client_method Okay ----------.\n");

#if 1 //Rio : Below needs to define: USE_CERT_BUFFERS_2048

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_load_verify_buffer Enter ----------.\n");

    ret = wolfSSL_CTX_load_verify_buffer(ctx, ca_cert_der_2048, sizeof(ca_cert_der_2048) / sizeof(char), SSL_FILETYPE_ASN1);

    if (  ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading ca_cert_der_2048, ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n", ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_load_verify_buffer Okay ----------.\n");

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_certificate_buffer enter ----------.\n");

    ret = wolfSSL_CTX_use_certificate_buffer(ctx, client_cert_der_2048, sizeof(client_cert_der_2048) / sizeof(char), SSL_FILETYPE_ASN1);

    if (ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading client_cert_der_2048, ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n", ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_certificate_buffer Okay ----------.\n");


    UART_printf("---------- Rio: tcpClientHandler: client_key_der_2048 enter ----------.\n");

    ret = wolfSSL_CTX_use_PrivateKey_buffer(ctx, client_key_der_2048,  sizeof(client_key_der_2048) / sizeof(char), SSL_FILETYPE_ASN1);

    if ( ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading client_key_der_2048, ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n",ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_PrivateKey_buffer Okay----------.\n");

#else //Rio: Below needs to define USE_CERT_BUFFERS_256

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_load_verify_buffer enter ----------.\n");

    ret = wolfSSL_CTX_load_verify_buffer(ctx, ecc_clikey_der_256, sizeof_ecc_clikey_der_256, SSL_FILETYPE_ASN1);

    if (ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading ecc_clikey_der_256, ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n",ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_load_verify_buffer Okay ----------.\n");

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_certificate_buffer enter ----------.\n");

    ret = wolfSSL_CTX_use_certificate_buffer(ctx, ecc_clikey_der_256, sizeof_ecc_clikey_der_256, SSL_FILETYPE_ASN1);

    if ( ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading ecc_clikey_der_256,  ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n",ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_certificate_buffer Okay ----------.\n");

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_PrivateKey_buffer enter ----------.\n");


    ret = wolfSSL_CTX_use_PrivateKey_buffer(ctx, ecc_clikey_der_256, sizeof_ecc_clikey_der_256, SSL_FILETYPE_ASN1);

    if ( ret != SSL_SUCCESS)
    {
        UART_printf("tcpHandler: Error loading ecc_clikey_der_256, ret_error = %d,"
                " please check the wolfssl/certs_test.h file.\n", ret);
        exitApp(ctx);
    }

    UART_printf("---------- Rio: tcpClientHandler: wolfSSL_CTX_use_PrivateKey_buffer Okay ----------.\n");

#endif


#if 1//Rio: Fix the User IO Callback, they need to be put here.
    /* Register callbacks */
    wolfSSL_SetIORecv(ctx, my_IORecv);
    wolfSSL_SetIOSend(ctx, my_IOSend);
#endif

    UART_printf("---------- Rio: tcpClientHandler: Error_init block Passed ----------.\n");

    IPN IPAddr = inet_addr("192.168.1.4");

    do
    {
        //static inline SOCKET socket(int domain, int type, int protocol)

        sockfd = socket(AF_INET, SOCK_STREAM, 0);
        if (sockfd == INVALID_SOCKET || sockfd == SOCKET_ERROR)
        {

            UART_printf("---------- tcpHandler: socket creation failed, sockfd value =%d ----------\n",sockfd);
            Task_sleep(1000);
            continue;
        }
        else
        {
            UART_printf("---------- tcpHandler: socket creation Success, sockfd value =%d ----------\n",sockfd);
        }

        memset((char *) &servAddr, 0, sizeof(servAddr));
        servAddr.sin_family = AF_INET;

        servAddr.sin_port = htons(TCPPORT_Client);
        //Rio: TCP port : 90 = 0x5A , convert to 0x5A00, 0x5A00 = 23040

        servAddr.sin_addr.s_addr = inet_addr(IP_ADDR);
        memset(servAddr.sin_zero, '\0', sizeof servAddr.sin_zero);//Rio: IP_ADDR= "192.168.1.2"

        UART_printf("---------- Rio: tcpClientHandler: Creating socket ==>  Server= 0x%x, port:%d /sin_port: %d ----------.\n", servAddr.sin_addr.s_addr, TCPPORT_Client, servAddr.sin_port);

        ret = connect(sockfd, (struct sockaddr *) &servAddr, sizeof(servAddr));

        if (ret < 0) {
            /* there was a problem getting the error code */
            UART_printf("---------- Rio: tcpClientHandler: Connecting connection Fail, close Socket !!, ret = %d ----------.\n",ret);

            fdClose((SOCKET) sockfd);
            Task_sleep(1000);
            continue;
        }
        else
        UART_printf("---------- Rio: tcpClientHandler: Connecting connection success ----------ret = %d.\n",strerror(ret));

    } while (ret != 0);

#if 1//Rio: This needs to be put here, otherwise, TLS will fail.
    if ((ssl = wolfSSL_new(ctx)) == NULL) {
        UART_printf("tcpHandler: wolfSSL_new error.\n");
        exitApp(ctx);
    }
#endif

    UART_printf("---------- Rio: tcpClientHandler:wolfSSL_new success, new SSL  okay ----------.\n");

    wolfSSL_set_fd(ssl, sockfd);


    ret = wolfSSL_connect(ssl);

    if (ret == SSL_SUCCESS)
    {

        UART_printf("---------- Rio: tcpClientHandler:wolfSSL_connect success ----------.\n");

        sockfd = wolfSSL_get_fd(ssl);

        /* Get a buffer to receive incoming packets. Use the default heap. */
        buffer = Memory_alloc(NULL, TCPPACKETSIZE, 0, &eb);

        if (buffer == NULL) {
            UART_printf("tcpWorker: failed to alloc memory\n");
            exitApp(ctx);
        }

        /* Say hello to the server */
        while (flag) {
            if (wolfSSL_write(ssl, msg, strlen(msg)) != strlen(msg)) {
                ret = wolfSSL_get_error(ssl, 0);
                UART_printf("Write error: %i.\n", ret);
            }
            while (internal_flag) {
                nbytes = wolfSSL_read(ssl, (char *) buffer, TCPPACKETSIZE);
                if (nbytes > 0) {
                    internal_flag = FALSE;
                }
            }
            /* success */
            //UART_printf("Heard: \"%s\".\n", buffer);
            UART_printf("---------- Rio: tcpClientHandler:wolfSSL_Heard: \"%s\" ----------.\n",buffer);

            wolfSSL_free(ssl);
            fdClose((SOCKET) sockfd);
            flag = FALSE;
        }

        /* Free the buffer back to the heap */
        Memory_free(NULL, buffer, TCPPACKETSIZE);

        UART_printf("---------- Rio: tcpClientHandler:wolfSSL Memory_free ----------.\n");

        /*
         *  Since deleteTerminatedTasks is set in the cfg file,
         *  the Task will be deleted when the idle task runs.
         */
        exitApp(ctx);

    }

    else

    {
        err = wolfSSL_get_error(ssl, ret);
        //wolfSSL_ERR_error_string(err, err_buffer);
        //Rio: SOCKET_ERROR_E               = -308,   /* error state on socket    */

        UART_printf("---------- Rio: tcpClientHandler:wolfSSL wolfSSL_connect, but wolfSSL_get_error = %d,%s ----------.\n",err,wolfSSL_ERR_error_string(err, err_buffer));

        wolfSSL_free(ssl);
        fdClose((SOCKET) sockfd);

        UART_printf("---------- Rio: tcpClientHandler:wolfSSL_connect failed, socket closed, wolfssl free! ----------.\n");
        fdCloseSession(TaskSelf());
        exitApp(ctx);
    }

//Close all the sockets, so return 0
    return(0);

}

//*****************************************************************************
//
// Hook function when network service open
//
//*****************************************************************************
void netOpenHook(void)
{
    print_mac();
    System_flush();

#ifdef SMC_RAW_SOCKET_USE
    Task_Params taskParams;

    /* Create a task */
    Task_Params_init(&taskParams);
    taskParams.priority = 1;
    Task_create ((ti_sysbios_knl_Task_FuncPtr)&Rawsocket, &taskParams, NULL);
#endif

#if 1//Rio: this is working well
    hEchoUdp = DaemonNew( SOCK_DGRAM, 0, UDPPORT, dtask_udp_echo,
                                OS_TASKPRINORM, OS_TASKSTKNORM, 0, 1 );
#endif

}

#ifdef SMC_RAW_SOCKET_USE
//*****************************************************************************
//
//! This task implements the E.thernet raw socket though NDK stack.
//
//*****************************************************************************
void Rawsocket(void)
{
    struct timeval to;
    SOCKET sraw = INVALID_SOCKET;
    int retVal, val;
    HANDLE phPkt;


    Task_sleep(1000);

    //
    // Open session
    //
    fdOpenSession( TaskSelf() );

    //
    // Create raw socket
    //
    sraw = socket(AF_RAWETH, SOCK_RAWETH, Eth_TYPE_NCSI);

    if( sraw == INVALID_SOCKET )
    {
        System_printf("Create socket: Error = %d\n", fdError());
        return;
    }

    //
    // Set hardware interface
    //
    val = 1;
    retVal = setsockopt(sraw, SOL_SOCKET, SO_IFDEVICE, &val, sizeof(val));

    if(retVal)
    {
        System_printf("Set hardware interface: Error = %d\n", fdError());
        fdCloseSession (TaskSelf());
        return;
    }

    //
    // Set priority
    //
//  val = 3;
//  retVal = setsockopt(sraw, SOL_SOCKET, SO_PRIORITY, &val, sizeof(val));
//
//  if(retVal)
//  {
//      System_printf("Set priority : Error = %d\n", fdError());
//      fdCloseSession (TaskSelf());
//      return -1;
//  }

    //
    // Set timeout
    to.tv_sec  = 10;
    to.tv_usec = 0;

    retVal = setsockopt( sraw, SOL_SOCKET, SO_RCVTIMEO, &to, sizeof( to ) );
    if(retVal)
    {
        System_printf("Set timeout : Error = %d\n", fdError());
        fdCloseSession (TaskSelf());
    }

    uint32_t ui32Lens;
    uint8_t* pRxBuf;
    uint8_t i;

    do
    {
        ui32Lens = recvnc(sraw, (void**)&pRxBuf, 0, &phPkt);

        System_printf("Recv: Lens = %d\n", ui32Lens);

        if(ui32Lens > 0)
        {
            for(i = 0; i < ui32Lens; i++)
            {
                System_printf("D[%d] = 0x%x\n", i, pRxBuf[i]);
            }
        }
    }
    while(1);


//   uint8_t pBuf[18] = {0xff, 0xff, 0xff, 0xff, 0xff, 0xff, //Dsc
//                          0x00, 0x12, 0xd1, 0x16, 0x79, 0x02, //Src
//                          0x88, 0xf8,                         //Eth Type
//                          0x00, 0x00, 0x00, 0x00};
//   if(send(sraw, pBuf, 18, 0)== -1)
//   {
//      System_printf("Fail socket, %d\n",fdError());
//      fdCloseSession (TaskSelf());
//      return NCSI_ERR_SEND;
//   }

}
#endif //SMC_RAW_SOCKET_USE



